/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.entity.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import net.regions_unexplored.entity.custom.RuBoat;
import net.regions_unexplored.entity.custom.RuChestBoat;
import org.jetbrains.annotations.NotNull;

public class RuBoatRenderer
extends BoatRenderer {
    private final Map<RuBoat.ModelType, Pair<ResourceLocation, ListModel<Boat>>> boatResources = (Map)Stream.of(RuBoat.ModelType.values()).collect(ImmutableMap.toImmutableMap(key -> key, model -> Pair.of((Object)new ResourceLocation("regions_unexplored", RuBoatRenderer.getTextureLocation(model, chest)), (Object)this.createBoatModel(context, (RuBoat.ModelType)((Object)model), chest))));

    public RuBoatRenderer(EntityRendererProvider.Context context, boolean chest) {
        super(context, false);
    }

    @NotNull
    public Pair<ResourceLocation, BoatModel> getModelWithLocation(Boat boat) {
        return boat instanceof RuChestBoat ? this.boatResources.get((Object)((RuChestBoat)boat).getModel()) : this.boatResources.get((Object)((RuBoat)boat).getModel());
    }

    private static String getTextureLocation(RuBoat.ModelType type, boolean chest) {
        return chest ? "textures/entity/chest_boat/" + type.getName() + ".png" : "textures/entity/boat/" + type.getName() + ".png";
    }

    private BoatModel createBoatModel(EntityRendererProvider.Context context, RuBoat.ModelType type, boolean hasChest) {
        ModelLayerLocation modellayerlocation = hasChest ? RuBoatRenderer.chestBoatTextureLocation(type) : RuBoatRenderer.boatTextureLocation(type);
        ModelPart baked = context.m_174023_(modellayerlocation);
        return hasChest ? new BoatModel(baked, true) : new BoatModel(baked, false);
    }

    private static ModelLayerLocation getModel(String name, String model) {
        return new ModelLayerLocation(new ResourceLocation("regions_unexplored", name), model);
    }

    public static ModelLayerLocation boatTextureLocation(RuBoat.ModelType type) {
        return RuBoatRenderer.getModel("boat/" + type.getName(), "main");
    }

    public static ModelLayerLocation chestBoatTextureLocation(RuBoat.ModelType type) {
        return RuBoatRenderer.getModel("chest_boat/" + type.getName(), "main");
    }
}

